<?php

namespace App\Http;

use App\Http\Middleware\Admin;
use App\Http\Middleware\ApiUser;
use App\Http\Middleware\CheckApi;
use App\Http\Middleware\Language;
use App\Http\Middleware\CheckInstall;
use App\Http\Middleware\StakingCheck;
use App\Http\Middleware\AuthUserCheck;
use App\Http\Middleware\CoinApiConfig;
use App\Http\Middleware\GiftCardCheck;
use App\Http\Middleware\PublicApiCall;
use App\Http\Middleware\WalletNotifier;
use App\Http\Middleware\CheckSwapStatus;
use App\Http\Middleware\DefaultLanguage;
use App\Http\Middleware\KYCVerification;
use App\Http\Middleware\PermissionAdmin;
use App\Http\Middleware\UserLastActivity;
use App\Http\Middleware\CheckDemoMiddleware;
use App\Http\Middleware\CheckCurrencyDeposit;
use App\Http\Middleware\CheckIcoFeature;
use App\Http\Middleware\CoWalletFeatureMiddleware;
use Illuminate\Foundation\Http\Kernel as HttpKernel;
use App\Http\Middleware\FutureWalletCreateMiddleware;
use App\Http\Middleware\MaintenanceModeCheckMiddleware;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array
     */
    protected $middleware = [
        \App\Http\Middleware\TrustProxies::class,
        \App\Http\Middleware\CheckForMaintenanceMode::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
        \Fruitcake\Cors\HandleCors::class
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            // \Illuminate\Session\Middleware\AuthenticateSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            UserLastActivity::class,
        ],

        'api' => [
            \App\Http\Middleware\ApiKeySecretMiddleware::class,
            'throttle:600,1',
            'bindings',
        ],
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array
     */
    protected $routeMiddleware = [
        'auth' => \App\Http\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'bindings' => \Illuminate\Routing\Middleware\SubstituteBindings::class,
        'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class,
        'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        'signed' => \Illuminate\Routing\Middleware\ValidateSignature::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
        'user' => AuthUserCheck::class,
        'admin' => Admin::class,
        'lang' => Language::class,
        'default_lang' => DefaultLanguage::class,
        'installation' => CheckInstall::class,
        'co-wallet' => CoWalletFeatureMiddleware::class,
        'config-api' => CoinApiConfig::class,
        'wallet_notify' => WalletNotifier::class,
        'api-user' => ApiUser::class,
        'checkApi' => CheckApi::class,
        'checkSwap' => CheckSwapStatus::class,
        'checkCurrencyDeposit' => CheckCurrencyDeposit::class,
        'kycVerification'=> KYCVerification::class,
        'maintenanceMode'=> MaintenanceModeCheckMiddleware::class,
        'last_seen' => UserLastActivity::class,
        'check_demo' => CheckDemoMiddleware::class,
        'permission' => PermissionAdmin::class,
        'publicSecret' => PublicApiCall::class,
        'createFutureWallet' => FutureWalletCreateMiddleware::class,
        'gift_card' => GiftCardCheck::class,
        'staking' => StakingCheck::class,
        'check_ico_module' => CheckIcoFeature::class,
        'generateSecret' => \App\Http\Middleware\GenerateSecretKey::class,
        'apiSecretCheck' => \App\Http\Middleware\ApiKeySecretMiddleware::class,
        'publicApiCheck' => \App\Http\Middleware\PrivateApiCheck::class,
        'privateIpRate' => \App\Http\Middleware\PrivateApiIpRateCheck::class,
    ];

    /**
     * The priority-sorted list of middleware.
     *
     * This forces non-global middleware to always be in the given order.
     *
     * @var array
     */
    protected $middlewarePriority = [
        \Illuminate\Session\Middleware\StartSession::class,
        \Illuminate\View\Middleware\ShareErrorsFromSession::class,
        \App\Http\Middleware\Authenticate::class,
        \Illuminate\Session\Middleware\AuthenticateSession::class,
        \Illuminate\Routing\Middleware\SubstituteBindings::class,
        \Illuminate\Auth\Middleware\Authorize::class,
    ];
}
